﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsMobile.DirectX;
using Microsoft.WindowsMobile.DirectX.Direct3D;

namespace Direct3D
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        Device device;

        CustomVertex.PositionColored[] werteksyTrojkata = new CustomVertex.PositionColored[3]
        { 
            new CustomVertex.PositionColored(
                new Vector3(-1, -1, 0),
                Color.Red.ToArgb()),
            new CustomVertex.PositionColored(
                new Vector3(0, 1, 0),
                Color.Yellow.ToArgb()),
            new CustomVertex.PositionColored(
                new Vector3(1, -1, 0),
                Color.Green.ToArgb()) 
        };
        VertexBuffer buforWerteksow;

        public void Initialize()
        {
            if (device == null)
            {
                //inicjacja urzadzenia
                PresentParameters pp = new PresentParameters();
                pp.Windowed = true;
                pp.SwapEffect = SwapEffect.Discard;
                device = new Device(
                    0,
                    DeviceType.Default,
                    this,
                    CreateFlags.None,
                    pp);

                device.RenderState.Lighting = false;
                device.RenderState.CullMode = Cull.None;

                device.DeviceReset += new EventHandler((object sender, EventArgs e) => { Initialize(); });
            }

            //macierz rzutowania
            float proporcjeObrazu = ((float)device.Viewport.Width) / device.Viewport.Height;
            device.Transform.Projection = Matrix.PerspectiveFovRH(                
                (float)(Math.PI/2),  // kąt widzenia
                proporcjeObrazu,     // proporcje obrazu (aspect ratio)
                1,                   // bliż
                100);                // dal
                
            //macierz widoku
            device.Transform.View = Matrix.LookAtRH(
                new Vector3(0, 0, 2),    // położenie kamery
                new Vector3(0, 0, 0),    // cel, na który jest skierowana
                new Vector3(0, 1, 0));   // polaryzacja (gdzie jest góra kamery)

            //macierz świata
            device.Transform.World = Matrix.Identity;

            //bufor werteksow
            buforWerteksow = new VertexBuffer(
                typeof(CustomVertex.PositionColored),
                3,
                device,
                Usage.WriteOnly,
                CustomVertex.PositionColored.Format,
                Pool.SystemMemory);
            buforWerteksow.SetData(werteksyTrojkata, 0, LockFlags.None);
        }
      
        private void Draw()
        {
            ustawMacierzSwiata();
            
            device.Clear(ClearFlags.Target, Color.Black, 1.0f, 0);
            device.BeginScene();

            //w tym miejscu umieścimy polecenia rysowania obiektów 3D
            device.SetStreamSource(0, buforWerteksow, 0);
            device.DrawPrimitives(PrimitiveType.TriangleList, 0, 1);            

            device.EndScene();
            device.Present();

            wyswietlPolozenie();
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            Draw();
        }

        protected override void OnPaintBackground(PaintEventArgs e)
        {
        }

        bool trwaPrzeciaganie = false;
        const float odsuniecie = 0.5f; //we wsp. ekranu
        private Vector3 poprzedniePolozenie = new Vector3(0, 0, 0);

        Matrix macierzTranslacji = Matrix.Identity;
        Matrix macierzObrotow = Matrix.Identity;

        Vector3 polozeniePrezentacja = new Vector3(0, 0, 0);

        private void Form1_MouseDown(object sender, MouseEventArgs e)
        {
            if (trwaPrzeciaganie) return;
            trwaPrzeciaganie = true; 

            poprzedniePolozenie = new Vector3(e.X, e.Y, odsuniecie);
            poprzedniePolozenie.Unproject(
                device.Viewport,
                device.Transform.Projection,
                device.Transform.View,
                macierzTranslacji);
        }

        private void Form1_MouseUp(object sender, MouseEventArgs e)
        {
            trwaPrzeciaganie = false; 
        }

        private void Form1_MouseMove(object sender, MouseEventArgs e)
        {
            if (!trwaPrzeciaganie) return;

            Vector3 polozenie = new Vector3(e.X, e.Y, odsuniecie);
            polozenie.Unproject(
                device.Viewport,
                device.Transform.Projection,
                device.Transform.View,
                macierzTranslacji);
            Vector3 przesuniecie = polozenie - poprzedniePolozenie;
            przesuniecie.Z = 0;                        

            macierzTranslacji *= Matrix.Translation(przesuniecie);

            polozeniePrezentacja += przesuniecie; //tylko do wyswietlania

            Invalidate();            
        }

        private void ustawMacierzSwiata()
        {
            device.Transform.World = Matrix.Identity;
            device.Transform.World *= macierzObrotow;
            device.Transform.World *= macierzTranslacji;
        }

        void wyswietlPolozenie()
        {
            Vector3 p = polozeniePrezentacja;
            string x = p.X.ToString(); if (x.Length > 5) x = x.Substring(0, 4);
            string y = p.Y.ToString(); if (y.Length > 5) y = y.Substring(0, 4);
            string z = p.Z.ToString(); if (z.Length > 5) z = z.Substring(0, 4);
            this.Text = x + " " + y + " " + z;
            this.Text += " " + (trwaPrzeciaganie ? "##" : "--");
        }

        private void timer1_Tick(object sender, EventArgs e)
        {            
            macierzObrotow *= Matrix.RotationY(0.1f);

            Invalidate();
        }        
    }
}